//
//  MCEventTracking.h
//  MCServerSupport
//
//  Created by Brent Gulanowski on 20/11/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//

#ifdef __IPHONE_OS_VERSION_MIN_REQUIRED
#import "MCTLog.h"
#else
#import <MCFoundation/MCLog.h>
#endif

#import <sys/syslog.h>


typedef enum {
	kMCEventLogLevelEmergency = LOG_EMERG,
	kMCEventLogLevelAlert     = LOG_ALERT,
	kMCEventLogLevelCritical  = LOG_CRIT,
	kMCEventLogLevelError     = LOG_ERR,
	kMCEventLogLevelWarning   = LOG_WARNING,
	kMCEventLogLevelNotice    = LOG_NOTICE,
	kMCEventLogLevelInfo      = LOG_INFO,
	kMCEventLogLevelDebug     = LOG_DEBUG,
	kMCEventLogLevelUser,
	kMCEventLogLevelUndefined = UINT_MAX,
} MCEventLogLevel;


extern void MCEventLogInit2( BOOL useSyslog, int facility );

#define MCEventLogInit( _flag_ ) MCEventLogInit2( _flag_, LOG_LOCAL3 )


// Extra info string is printed on error, debug and user logs (those that also show file name and line number)
extern void MCEventInfoInit(void);
extern void MCEventSetExtraInfo( NSString *infoString );
extern NSString *MCEventExtraInfo( void );

// a good value for user is the user's MCLogEmployee value
extern id MCEventLog(MCEventLogLevel level, unsigned user, const char *filePath, int lineNumber, NSString *format, ...);


#define MCLog0(_format_, _args_...)          MCEventLog(kMCEventLogLevelEmergency, 0, __FILE__, __LINE__, _format_, ## _args_)
#define MCLog1(_format_, _args_...)          MCEventLog(kMCEventLogLevelAlert,     0, __FILE__, __LINE__, _format_, ## _args_)
#define MCLog2(_format_, _args_...)          MCEventLog(kMCEventLogLevelCritical,  0, __FILE__, __LINE__, _format_, ## _args_)
#define MCLog3(_format_, _args_...)          MCEventLog(kMCEventLogLevelError,     0, __FILE__, __LINE__, _format_, ## _args_)
#define MCLog4(_format_, _args_...)          MCEventLog(kMCEventLogLevelWarning,   0, __FILE__, __LINE__, _format_, ## _args_)
#define MCLog5(_format_, _args_...)          MCEventLog(kMCEventLogLevelNotice,    0, __FILE__, __LINE__, _format_, ## _args_)
#define MCLog6(_format_, _args_...)          MCEventLog(kMCEventLogLevelInfo,      0, __FILE__, __LINE__, _format_, ## _args_)
#define MCLog7(_format_, _args_...)          MCEventLog(kMCEventLogLevelDebug,     0, __FILE__, __LINE__, _format_, ## _args_)

#ifdef MCDEBUG
#define MCLog8(_user_, _format_, _args_...)  MCEventLog(kMCEventLogLevelUser, _user_, __FILE__, __LINE__, _format_, ## _args_)
#else
#define MCLog8(_user_, _format_, _args_...)
#endif


#define MCLogEmergency  MCLog0
#define MCEmergencyLog  MCLog0
#define MCLogAlert      MCLog1
#define MCAlertLog      MCLog1
#define MCLogCritical   MCLog2
#define MCCriticalLog   MCLog2
#define MCLogError      MCLog3
//#define MCErrorLog      MCLog3
#define MCLogWarning    MCLog4
#define MCWarningLog    MCLog4
#define MCLogNotice     MCLog5
#define MCNoticeLog     MCLog5
#define MCLogInfo       MCLog6
#define MCInfoLog       MCLog6
#define MCLogDebug      MCLog7
//#define MCDebugLog     MCLog7
#define MCLogUser       MCLog8
#define MCUserLog       MCLog8


#define MCLogMC(_format_, _args_...)  MCLog8( MCLogEmployeeMike,    _format_, ## _args_)
#define MCLogAL(_format_, _args_...)  MCLog8( MCLogEmployeeAli,     _format_, ## _args_)
#define MCLogAJ(_format_, _args_...)  MCLog8( MCLogEmployeeAJ,      _format_, ## _args_)
#define MCLogBG(_format_, _args_...)  MCLog8( MCLogEmployeeBrent,   _format_, ## _args_)
#define MCLogFK(_format_, _args_...)  MCLog8( MCLogEmployeeFraser,  _format_, ## _args_)
#define MCLogKH(_format_, _args_...)  MCLog8( MCLogEmployeeKevin,   _format_, ## _args_)
#define MCLogSB(_format_, _args_...)  MCLog8( MCLogEmployeeSeb,     _format_, ## _args_)
#define MCLogOP(_format_, _args_...)  MCLog8( MCLogEmployeeOscar,   _format_, ## _args_)
#define MCLogPR(_format_, _args_...)  MCLog8( MCLogEmployeePatrick, _format_, ## _args_)
#define MCLogTB(_format_, _args_...)  MCLog8( MCLogEmployeeThomas, _format_, ## _args_)

// Just log where you are in the code
#define MCLoc()   MCLog7( @"%@", NSStringFromSelector(_cmd))

// Logs for individual programmers
#define MCLocMC() MCLog8( MCLogEmployeeMike,    @"%@", NSStringFromSelector(_cmd))
#define MCLocAL() MCLog8( MCLogEmployeeAli,     @"%@", NSStringFromSelector(_cmd))
#define MCLocAJ() MCLog8( MCLogEmployeeAJ,      @"%@", NSStringFromSelector(_cmd))
#define MCLocBG() MCLog8( MCLogEmployeeBrent,   @"%@", NSStringFromSelector(_cmd))
#define MCLocFK() MCLog8( MCLogEmployeeFraser,  @"%@", NSStringFromSelector(_cmd))
#define MCLocKH() MCLog8( MCLogEmployeeKevin,   @"%@", NSStringFromSelector(_cmd))
#define MCLocSB() MCLog8( MCLogEmployeeSeb,     @"%@", NSStringFromSelector(_cmd))
#define MCLocOP() MCLog8( MCLogEmployeeOscar,   @"%@", NSStringFromSelector(_cmd))
#define MCLocPR() MCLog8( MCLogEmployeePatrick, @"%@", NSStringFromSelector(_cmd))
#define MCLocTB() MCLog8( MCLogEmployeeThomas,  @"%@", NSStringFromSelector(_cmd))


// define this either in your target settings or in specific implementation files to get standard MCLog behaviour
#ifndef MCPreventMCLogRedefine

//#define MCLog(_selector_, _object_, _format_, _args_...) MCEventLog(kMCEventLogLevelInfo, 0, __FILE__, __LINE__, _format_, ## _args_)

#undef  MCErrorLog
#define MCErrorLog  MCLog3

#undef  MCDebugLog
#define MCDebugLog MCLog7

#endif

